%P48p_readin ... read in a night's worth of pointing file
%specify INFILE, e.g. INFILE='P2021_02_04.csv'
%generates key data arrays for pointing analysis

%--------------------------------------------------------------------------
flag=exist('INFILE','var');
if ~flag; disp ('INFILE not defined; return'); return; end
OFILE_PRE=regexprep(INFILE,'.csv','');
%--------------------------------------------------------------------------

%--------------------------------------------------------------------------
fid=fopen(INFILE);
A=textscan(fid,'%s %s %s %s %s %f %f','DeLimiter',',','HeaderLines',1);
fclose (fid);
%--------------------------------------------------------------------------
    B=A{1};     %date
    DATE=char(regexprep(B(1),' .*$',''));    

    t_start = sex2hr(regexprep(A{1},'^.* ',''));     %start time, hours
    t_end  = sex2hr(regexprep(A{2},'^.* ',''));     %end time, hours
    ra     = sex2hr(regexprep(A{3},'^.* ',''))*15;  %ra in degrees
    dec    = sex2deg(regexprep(A{4},'^.* ',''));    %dec in degrees
    ha     = sex2deg(regexprep(A{5},'^.* ',''));    %ha in signed hours
    raoff = A{6}';      %offset in ra, arcseconds
    decoff= A{7}';      %offset in dec, arcseconds
    
    P.INFILE=INFILE;
    P.DATE=DATE;
    P.OF=OFILE_PRE;
    P.t_start=t_start;
    P.t_end=t_end;
    P.ra=ra;
    P.dec=dec;
    P.ha=ha;
    P.raoff=raoff;
    P.decoff=decoff;
    P.m_raoff=zeros(size(raoff));
    P.m_decoff=zeros(size(raoff));
    P.m_era=zeros(size(raoff));
    P.m_edec=zeros(size(raoff));
    
%--------------------------------------------------------------------------    
clear flag OFILE_PRE fid A B
clear INFILE DATE t_start t_end ra dec ha raoff decoff 
%-------------------------------------------------------------------------- 

