%build_TP_model
%builds TPoint model using concatenation of all available .model files
%for now the median is taken

    MODELFILE='all.model';
    A=readmatrix(MODELFILE,'FileType','text','Delimiter',' ');
    ME=A(:,1);
    MA=A(:,2);
    NP=A(:,3);
    CH=A(:,4);
    FO=A(:,5);
    ID=A(:,6);
    IH=A(:,7);

    figure(1); tl=tiledlayout(1,2);
    nexttile
        plot(IH,'+:k')
        ylabel('IH (")')
        set(gca,'FontSize',16,'LineWidth',2)
        pbaspect([3 1 1])
    nexttile
        plot(ID,'+:k')
        xlabel('day index')
        ylabel('ID (")')
        set(gca,'FontSize',16,'LineWidth',2)
        pbaspect([3 1 1])
    exportgraphics(tl,'HA_DEC_zeropoint.png')
    
    figure(2); tl=tiledlayout(3,1);
    nexttile
        plot(ME,'+:k')
        ylabel('ME (")')
        set(gca,'FontSize',16,'LineWidth',2)
        pbaspect([3 1 1])
    nexttile
        plot(MA,'+:k')
        xlabel('day index')
        ylabel('MA (")')
        set(gca,'FontSize',16,'LineWidth',2)
        pbaspect([3 1 1])
    nexttile
        plot(NP,'+:k')
        ylabel('NP (")')
        set(gca,'FontSize',16,'LineWidth',2)
        pbaspect([3 1 1])
    exportgraphics(tl,'ME_MA_CH.png')
    
    figure(3); tl=tiledlayout(1,2);
    nexttile
        plot(CH,'+:k')
        xlabel('day index')
        ylabel('CH (")')
        set(gca,'FontSize',16,'LineWidth',2)
        pbaspect([3 1 1])
    nexttile
        plot(FO,'+:k')
        xlabel('day index')
        ylabel('FO (")')
        set(gca,'FontSize',16,'LineWidth',2)
        pbaspect([3 1 1])
    exportgraphics(tl,'CH_FO.png')

    MODEL.ME=median(ME);
    MODEL.MA=median(MA);
    MODEL.NP=median(NP);
    MODEL.CH=median(CH);
    MODEL.FO=median(FO);
    MODEL.ID=median(ID);
    MODEL.IH=median(IH);
    
    fprintf('ME: %5.1f\n',MODEL.ME);
    fprintf('MA: %5.1f\n',MODEL.MA);
    fprintf('NP: %5.1f\n',MODEL.NP);
    fprintf('CH: %5.1f\n',MODEL.CH);
    fprintf('FO: %5.1f\n',MODEL.FO);
    fprintf('ID: %5.1f\n',MODEL.ID);
    fprintf('IH: %5.1f\n',MODEL.IH);
    
    
     clear MODELFILE A ME MA NP CH FO ID IH tl 
