% plot residual RA & DEC offsets for bands of HA and DEC

close all
    PRINT_FLAG=1;
    DATE=P.DATE;
    OF=[P.OF '_res'];
    
    [m_raoff,m_decoff]=model_offsets(MODEL,P.ha,P.dec);
    era=P.raoff-m_raoff;
    edec=P.decoff-m_decoff;
    
    YL=[-60 60];
    figure
    ra_offsets_DEC_fixed (YL,PRINT_FLAG,DATE,OF,P.ha,P.dec,era)
    figure
    dec_offsets_DEC_fixed(YL,PRINT_FLAG,DATE,OF,P.ha,P.dec,edec)

    figure
    ra_offsets_ha_fixed(YL,PRINT_FLAG,DATE,OF,P.ha,P.dec,era)
    figure
    dec_offsets_ha_fixed(YL,PRINT_FLAG,DATE,OF,P.ha,P.dec,edec)
    
    clear PRINT_FLAG DATE OF  m_raoff m_decoff era edec YL