%--------------------------------------------------------------------------
function fourpanel_plot(PRINT_FLAG,DATE,OF,RADIUS,ha,dec,raoff,decoff,era,edec)
%--------------------------------------------------------------------------
tl=tiledlayout(2,2);
    nexttile
        plot(ha,dec,'.k')       %locations we observed in ha-dec plane
        xlabel('HA (hr)')
        ylabel('\delta (^\circ)')
        xlim([-6 6])
        ylim([-30 90])
        title(DATE)
        set(gca,'FontSize',16,'LineWidth',2)
        axis square
    nexttile
        plot(raoff,decoff,'.k')     %measured offsets in ra-dec plane
        xlabel('{\Delta}\alpha*(")')
        ylabel('{\Delta}\delta (")')
        title ('offsets')
        xlim([-180 180])
        ylim([-180 180])
        axis square
        set(gca,'FontSize',16,'LineWidth',2)
    nexttile
        ind=sqrt(era.*era+edec.*edec)>RADIUS;
        plot(ha(ind),dec(ind),'.k')         %plot outlier (ha,dec) pointings
        title(sprintf('residual>%d"',RADIUS))
        xlabel('HA (hr)')
        ylabel('\delta (^\circ)')
        set(gca,'FontSize',16,'LineWidth',2)
        axis square
    nexttile
        plot(era,edec,'.k')     %plot ra and dec residuals in ra-dec plane
        xlabel('{\Delta}\alpha* (")')
        ylabel('{\Delta}\delta (")')
        ylim([-60 60])
        xlim([-60 60])
        title ('resdiuals');
        set(gca,'FontSize',16,'LineWidth',2)
        if ~ishold, hold on, end
        rectangle('Position',[-1 -1 2 2]*RADIUS,'Curvature',[1 1],...
        'EdgeColor','r','LineStyle','-','LineWidth',2)
        hold off
        axis square
exportgraphics(tl,[OF '_postfit.png'])
end