function x=genX_tpoint(h,d)
%generates two lines of X-array, assuming TPOINT model
%inputs: HA (h, hours) and declination (d, degrees)

sh=sind(h*15);
ch=cosd(h*15);
td=tand(d);
sd=secd(d);

x(1,:)=[sh*td -ch*td td sd 0  0 1];
x(2,:)=[ch     sh    0  0  ch 1 0];

return
end