function [m_raoff, m_decoff]=model_offsets(MODEL,ha,dec)
%compute model offsets given MODEL structure, ha and dec
   ME = MODEL.ME;       
   MA = MODEL.MA;
   NP = MODEL.NP;
   CH = MODEL.CH;
   FO = MODEL.FO;
   ID = MODEL.ID;
   IH = MODEL.IH;

   m_raoff=((ME*sind(ha*15)-MA*cosd(ha*15)).*tand(dec)+...
       NP*tand(dec) + CH*secd(dec) + IH).*cosd(dec);
   m_decoff=(ME+FO)*cosd(ha*15) + MA*sind(ha*15) + ID;

end