%--------------------------------------------------------------------------
function ra_offsets_DEC_fixed (YL,PRINT_FLAG,DATE,OF,ha,dec,raoff)
%plot ra offsets as a function of HA for bands of declination
%--------------------------------------------------------------------------
    ylab='\Delta\alpha*(")';
    tl=tiledlayout(3,1);
    nexttile
        dec_begin=-30; dec_end=30;
        str=sprintf('%s:  %d  < DEC < %d',DATE,dec_begin,dec_end);
        ind=(dec>dec_begin) & (dec<dec_end);
            x=ha(ind); y=raoff(ind);
            ind2=dec(ind)>0;
            plot(x(ind2),y(ind2),'+g')
            if ~ishold, hold on, end
            plot(x(~ind2),y(~ind2),'+r')
            hold off
            xlim([-6 6])
            ylabel(ylab)
            title(str)
            legend('\delta>0','\delta<0','location','northeastoutside')
            set(gca,'FontSize',16,'LineWidth',2) 
            ylim(YL)
    nexttile
        dec_begin=30; dec_end=60;
        str=sprintf('%s:  %d  < DEC < %d',DATE,dec_begin,dec_end);
        ind=(dec>dec_begin) & (dec<dec_end);
        plot_offsets_ha(ha(ind),raoff(ind),YL,str,ylab)
    nexttile
        dec_begin=60; dec_end=90;
        str=sprintf('%s:  %d  < DEC < %d',DATE,dec_begin,dec_end);
        ind=(dec>dec_begin) & (dec<dec_end);
        plot_offsets_ha(ha(ind),raoff(ind),YL,str,ylab)
        xlabel('HA (hr)')
    if (PRINT_FLAG==1)
        str=[OF '_ra_offsets_dec_fixed.png'];
        exportgraphics(tl,str)
    end
    return
end
