%--------------------------------------------------------------------------
function ra_offsets_ha_fixed (YL,PRINT_FLAG,DATE,OF,ha,dec,raoff)
%plot ra offsets as a function of DEC for bands of HA     
%--------------------------------------------------------------------------
    ylab='\Delta\alpha*(")';
    tl=tiledlayout(3,1);
    nexttile
        ha_begin=-6; ha_end=-2;
        str=sprintf('%s:  %d hr < HA < %d hr',DATE,ha_begin,ha_end);
        ind=(ha>ha_begin) & (ha<ha_end);
        plot_offsets_dec (dec(ind),raoff(ind),YL,str,ylab)
    nexttile
        ha_begin=-2; ha_end=0;
        str=sprintf('%s:  %d hr < HA < ',DATE,ha_begin);
        ind=(ha>ha_begin) & (ha<ha_end);
        plot(dec(ind),raoff(ind),'.r')
        if ~ishold, hold on, end
            ha_begin=0; ha_end=+2;
            str=[str sprintf(' %d hr',ha_end)];
            ind=(ha>ha_begin) & (ha<ha_end);        
            plot(dec(ind),raoff(ind),'.g')
        hold off
        ylabel(ylab)
        title(str)
        set(gca,'FontSize',16,'LineWidth',2) 
        axis manual; ylim(YL); xlim([-30 90])
        legend('HA<0','HA>0','location','northeastoutside')
    nexttile  
        ha_begin=2; ha_end=+6;
        str=sprintf('%s:  %d hr < HA < %d hr',DATE,ha_begin,ha_end);
        ind=(ha>ha_begin) & (ha<ha_end);
        plot_offsets_dec(dec(ind),raoff(ind),YL,str,ylab)
        xlabel('\delta(^\circ)')
    if (PRINT_FLAG==1)
        str=[OF '_ra_offsets_ha_fixed.png'];
        exportgraphics(tl,str)
    end
    
    return
end