%gen_tpoint
%generates 7-parameter TPOINT model using data in structure P
%writes out 7 parameters into structure P

OF=P.OF;
OUTFILE=[OF '.model'];
fout=fopen(OUTFILE,'w');

    ha=P.ha;
    dec=P.dec;
    raoff=P.raoff;
    decoff=P.decoff;
%--------------------------------------------------------------------------
% form the X-array and y-array (in preparation for Least-squares)
%--------------------------------------------------------------------------
    n=numel(ha);
    X=zeros(2*n,7);
    y=zeros(2*n,1);

    for j=1:n
        ind=2*j-1;  %convert raoff1 to haoff1 (see Wallace & Tritton 1976)
        y(ind)=raoff(j)/cosd(dec(j));
        y(ind+1)=decoff(j);
        
        xhd = genX_tpoint(ha(j),dec(j));
        X(ind,:)=xhd(1,:);
        X(ind+1,:)=xhd(2,:);
    end
%--------------------------------------------------------------------------
% solve
%--------------------------------------------------------------------------
    D=X'*X;
    b_hat=D\X'*y;       %model parameter column
    
%populate model-parameter structure
    MODEL.ME=b_hat(1);        %
    MODEL.MA=b_hat(2);
    MODEL.NP=b_hat(3);
    MODEL.CH=b_hat(4);
    MODEL.FO=b_hat(5);
    MODEL.ID=b_hat(6);
    MODEL.IH=b_hat(7);
    fprintf(fout,[repmat('%f ',1,7) '\n'],b_hat);
fclose(fout);
    
%--------------------------------------------------------------------------
clear OF OUTFILE fout ha dec raoff decoff 
clear n X y j ind xhd D b_hat     
%--------------------------------------------------------------------------
